/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.resources.bbmodel;

import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import immersive_aircraft.resources.bbmodel.BBAnimation;
import immersive_aircraft.resources.bbmodel.BBKeyframe;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BBAnimator {
    Map<Channel, List<BBKeyframe>> frames = new EnumMap<Channel, List<BBKeyframe>>(Channel.class);
    Map<Channel, int[]> frameLookup = new EnumMap<Channel, int[]>(Channel.class);

    public BBAnimator(JsonObject element, BBAnimation animation) {
        element.getAsJsonArray("keyframes").forEach(entry -> {
            BBKeyframe frame = new BBKeyframe(entry.getAsJsonObject());
            this.frames.computeIfAbsent(frame.channel, k -> new LinkedList()).add(frame);
        });
        for (int i = 0; i < Channel.values().length; ++i) {
            Channel channel = Channel.values()[i];
            List keyframes = this.frames.computeIfAbsent(channel, k -> new LinkedList());
            this.frameLookup.put(channel, new int[animation.frameCount]);
            keyframes.sort((a, b) -> Float.compare(a.time, b.time));
            if (keyframes.isEmpty()) continue;
            int lastLookupIndex = 0;
            int frameIndex = 0;
            for (BBKeyframe keyframe : keyframes) {
                int lookupIndex = animation.toFrameIndex(keyframe.time);
                for (int j = lastLookupIndex; j < lookupIndex; ++j) {
                    this.frameLookup.get((Object)((Object)channel))[j] = frameIndex;
                }
                lastLookupIndex = lookupIndex;
                ++frameIndex;
            }
        }
    }

    public Vector3f sample(BBAnimation animation, Channel channel, float time) {
        List<BBKeyframe> keyframes = this.frames.get((Object)channel);
        if (keyframes.isEmpty()) {
            if (channel == Channel.SCALE) {
                return new Vector3f(1.0f, 1.0f, 1.0f);
            }
            return new Vector3f();
        }
        time = animation.length == 0.0f ? 0.0f : (time %= animation.length);
        int frameIndex = animation.toFrameIndex(time);
        int i = this.frameLookup.get((Object)channel)[frameIndex];
        BBKeyframe first = keyframes.get(i);
        BBKeyframe second = keyframes.get((i + 1) % keyframes.size());
        if (first.time == second.time) {
            return first.evaluate();
        }
        float delta = (time - first.time) / (second.time - first.time);
        Vector3f firstVector = first.evaluate();
        firstVector.m_122261_(1.0f - delta);
        Vector3f secondVector = second.evaluate();
        secondVector.m_122261_(delta);
        firstVector.m_122253_(secondVector);
        return firstVector;
    }

    public static enum Channel {
        POSITION,
        ROTATION,
        SCALE;

    }
}

